package org.msh.tb.bd.dashboard.query;

import org.msh.tb.entities.enums.CaseClassification;
import org.msh.tb.entities.enums.Gender;

import java.util.List;

/**
 * Created by Mauricio on 12/06/2017.
 */
public class GeoDistributionQuery extends IndicatorQuery {

    private CaseClassification caseClassification;
    private Gender gender;
    private boolean consolidateByLowerLevel;

    /**
     * @return The result used by IndicatorParser to create the dashboard summarized report.
     */
    @Override
    public List<Object[]> getSummaryResult(){
        return getDetailedResult();
    }

    /**
     * @return The result used by DetailedIndicator to mount the detailed reports.
     */
    @Override
    public List<Object[]> getDetailedResult(){
        // create administrative unit condition
        String auCondition = "";

        if (getSelectedAdminUnit() != null) {
            auCondition = "and au.code like '" + getSelectedAdminUnit().getCode() + "%' ";
        }

        // no need to add rate (no rate defined) and no need to add root results
        return getQueryResult(auCondition);
    }

    @Override
    public Float calculateRate(Object[] o) {
        return null;
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        String tbCaseCond = "";
        String levelCond;

        if (caseClassification != null) {
            tbCaseCond = tbCaseCond.concat(" and c.classification = " + caseClassification.ordinal() + " ");
        }

        if (gender != null) {
            tbCaseCond = tbCaseCond.concat(" and p.gender = " + gender.ordinal() + " ");
        }

        if (consolidateByLowerLevel) {
            levelCond = " and au.countryStructure.level = 3 "; // upazilla level
        } else {
            int level = 1;
            if (getSelectedAdminUnit() != null) {
                level = getSelectedAdminUnit().getCountryStructure().getLevel() + 1;
            }
            levelCond = " and au.countryStructure.level = " + level + " ";
        }

        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select au, " +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate " +
                    tbCaseCond + " and p.workspace.id = :wsId) " +
                "from AdministrativeUnit au " +
                "where au.workspace.id = :wsId " + adminUnitCondition + levelCond +
                " and (select count(*) " +
                        "from TbCase c join c.patient p " +
                        "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                        "and c.registrationDate between :iniDate and :endDate " +
                        tbCaseCond + " and p.workspace.id = :wsId) > 0 " +
                "order by au.code")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }

    public CaseClassification getCaseClassification() {
        return caseClassification;
    }

    public void setCaseClassification(CaseClassification caseClassification) {
        this.caseClassification = caseClassification;
    }

    public Gender getGender() {
        return gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public boolean isConsolidateByLowerLevel() {
        return consolidateByLowerLevel;
    }

    public void setConsolidateByLowerLevel(boolean consolidateByLowerLevel) {
        this.consolidateByLowerLevel = consolidateByLowerLevel;
    }
}
